/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.reality;

import dev.xkmc.curseofpandora.content.complex.AttrAdder;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ISlotAdderItem;
import dev.xkmc.curseofpandora.content.complex.ListTickingToken;
import dev.xkmc.curseofpandora.content.complex.SlotAdder;
import dev.xkmc.curseofpandora.content.reality.CursePandoraUtil;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.data.CoPTagGen;
import dev.xkmc.curseofpandora.init.registrate.CoPEffects;
import dev.xkmc.l2complements.mixin.LevelAccessor;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2library.base.effects.ClientEffectCap;
import dev.xkmc.l2library.capability.conditionals.NetworkSensitiveToken;
import dev.xkmc.l2library.capability.conditionals.TokenKey;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.Nullable;

public class CurseOfPrudenceItem
extends ISlotAdderItem<Ticker> {
    public static final TokenKey<Ticker> KEY = new TokenKey("curseofpandora", "curse_of_prudence");
    private static final AttrAdder R = CursePandoraUtil.reality(KEY);
    private static final AttrAdder S = CursePandoraUtil.spell(KEY);
    public static final SlotAdder ADDER = SlotAdder.of("curse_of_prudence", CoPConfig.COMMON.curse.curseOfPrudenceSlot);

    public static int getMaxLevel() {
        return (Integer)CoPConfig.COMMON.curse.curseOfPrudenceMaxLevel.get();
    }

    public static double getDamageFactor() {
        return (Double)CoPConfig.COMMON.curse.curseOfPrudenceDamageFactor.get();
    }

    public static int getDuration() {
        return (Integer)CoPConfig.COMMON.curse.curseOfPrudenceDuration.get();
    }

    public static double getMaxHurtDamage() {
        return (Double)CoPConfig.COMMON.curse.curseOfPrudenceMaxDamage.get();
    }

    public CurseOfPrudenceItem(Item.Properties properties) {
        super(properties, Ticker::new, ADDER, R, S);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        int dur = CurseOfPrudenceItem.getDuration();
        int damage = (int)Math.round(CurseOfPrudenceItem.getDamageFactor() * 100.0);
        int hurt = (int)Math.round(CurseOfPrudenceItem.getMaxHurtDamage() * 100.0);
        list.add((Component)CoPLangData.Reality.PRUDENCE_1.get(dur / 20, damage).m_130940_(ChatFormatting.RED));
        list.add((Component)CoPLangData.Reality.PRUDENCE_2.get(hurt).m_130940_(ChatFormatting.RED));
    }

    @SerialClass
    public static class Ticker
    extends ListTickingToken
    implements IAttackListenerToken,
    NetworkSensitiveToken<Ticker> {
        @SerialClass.SerialField
        public HashMap<UUID, HashSet<Long>> fear = new HashMap();
        private boolean sync = false;

        public Ticker() {
            super(List.of(ADDER, R, S));
        }

        @Override
        protected void removeImpl(Player player) {
            super.removeImpl(player);
            this.removeEffect(player);
            this.fear.clear();
        }

        @Override
        protected void tickImpl(Player player) {
            super.tickImpl(player);
            Level level = player.m_9236_();
            this.sync = false;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                ServerLevel sl = sp.m_284548_();
                this.sync |= this.fear.entrySet().removeIf(ent -> {
                    LivingEntity le;
                    Entity patt3432$temp = sl.m_8791_((UUID)ent.getKey());
                    if (!(patt3432$temp instanceof LivingEntity) || !(le = (LivingEntity)patt3432$temp).m_6084_()) {
                        return true;
                    }
                    this.sync |= ((HashSet)ent.getValue()).removeIf(t -> level.m_46467_() >= t + (long)CurseOfPrudenceItem.getDuration());
                    return ((HashSet)ent.getValue()).isEmpty();
                });
                if (this.sync) {
                    this.sync(sp);
                }
            } else {
                this.checkEffect(player);
            }
        }

        @Override
        public void onPlayerDamageTarget(Player player, AttackCache cache) {
            int count;
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            long time = player.m_9236_().m_46467_();
            LivingEntity target = cache.getAttackTarget();
            if (target == player) {
                return;
            }
            Set list = this.fear.get(target.m_20148_());
            int n = count = list == null ? 0 : list.size();
            if (count > 0) {
                LivingDamageEvent event = cache.getLivingDamageEvent();
                assert (event != null);
                if (!event.getSource().m_269533_(DamageTypeTags.f_273918_)) {
                    count = Math.min(count, CurseOfPrudenceItem.getMaxLevel());
                    cache.addDealtModifier(DamageModifier.multTotal((float)((float)Math.pow(CurseOfPrudenceItem.getDamageFactor(), count))));
                }
            }
            this.fear.computeIfAbsent(target.m_20148_(), k -> new HashSet()).add(time);
            this.sync(sp);
            if (cache.getAttackTarget().m_6095_().m_204039_(CoPTagGen.PRUDENCE_WHITELIST)) {
                return;
            }
            if (cache.getAttackTarget().m_21223_() <= player.m_21223_()) {
                return;
            }
            double maxDamage = (double)cache.getAttackTarget().m_21233_() * CurseOfPrudenceItem.getMaxHurtDamage();
            cache.addDealtModifier(DamageModifier.nonlinearFinal((int)9000, e -> Math.min(e, (float)maxDamage)));
        }

        private void sync(ServerPlayer sp) {
            this.sync(KEY, this, sp);
        }

        public void onSync(@Nullable Ticker old, Player player) {
            if (old != null) {
                old.removeEffect(player);
            }
            this.checkEffect(player);
        }

        private void removeEffect(Player player) {
            if (!player.m_9236_().m_5776_()) {
                return;
            }
            for (UUID id : this.fear.keySet()) {
                Entity ent = (Entity)((LevelAccessor)player.m_9236_()).callGetEntities().m_142694_(id);
                if (!(ent instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)ent;
                ClientEffectCap cap = (ClientEffectCap)ClientEffectCap.HOLDER.get((ICapabilityProvider)le);
                cap.map.remove(CoPEffects.PRUDENCE.get());
            }
        }

        private void checkEffect(Player player) {
            if (!player.m_9236_().m_5776_()) {
                return;
            }
            for (Map.Entry<UUID, HashSet<Long>> pair : this.fear.entrySet()) {
                Entity ent = (Entity)((LevelAccessor)player.m_9236_()).callGetEntities().m_142694_(pair.getKey());
                if (!(ent instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)ent;
                ClientEffectCap cap = (ClientEffectCap)ClientEffectCap.HOLDER.get((ICapabilityProvider)le);
                cap.map.put((MobEffect)CoPEffects.PRUDENCE.get(), 0);
            }
        }
    }
}

